# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 5
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR5_strategy.txt
# LLM Suggested Fallback: D

def shadow_whisperer(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"  # Initial cooperation to signal willingness
    
    current_round = len(my_history)
    total_rounds = 10
    
    # Detect unconditional strategies
    is_always_c = "return \"C\"" in opponent_program_code or "always_cooperate" in opponent_program_code.lower()
    is_always_d = "return \"D\"" in opponent_program_code or "always_defect" in opponent_program_code.lower()
    
    if is_always_c:
        return "D"  # Exploit always-cooperators
    if is_always_d:
        return "C" if current_round % 2 == 0 else "D"  # Alternate to minimize losses
    
    # Late-game adjustment
    if current_round >= total_rounds - 2:
        return "D"
    
    # Check for repeated defections
    if len(opp_history) >= 3 and all(move == "D" for move in opp_history[-3:]):
        return "D"
    
    # Tit-for-Tat with 10% noise
    if random.random() < 0.1:
        return "D"
    return opp_history[-1]